Rem PathEffects.vbs
Rem An InDesign VBScript
Rem
Rem Effects:
Rem Punk: Pushes the control handles on all of the points on the path toward the geometric center of the path.
Rem Bloat: Pushes the control handles on all of the points on the path away from the geometric enter of the path.
Rem PunkBloat: Pushes the left direction handle toward the center of the path and pushes the
Rem right direction handle away from the center of the path.
Rem BloatPunk: Pushes the right direction handle toward the center of the path and pushes the left
Rem direction handle away from the center of the path.
Rem Twirl: Pushes all right direction handles toward the center of the path and leaves the left direction handle unchanged.
Rem AntiTwirl: Pushes all left direction handles toward the center of the path and leaves the right direction handles unchanged.
Rem Retract All: Retracts all control handles.
Rem MakeRectangle: Converts the selected object to a rectangle.
Rem MakeOval: Converts the selected object to an oval.
Rem Turn on the Copy Path option to apply the effect to a duplicate of the selected path(s).
Rem Note that some settings for some of these effects are mathematically equivalent. For example, choosing Bloat and
Rem setting the Distance from Center Point field to -50 is the same as choosing Punk and setting the Offset from
Rem Center Point field to 50.
Rem
Rem For more on InDesign/InCopy scripting see the documentation included in the Scripting SDK 
Rem available at http://www.adobe.com/devnet/indesign/sdk.html
Rem or visit the InDesign scripting user to user forum at http://www.adobeforums.com.
Rem
main
Function main()
	ReDim myObjectList(0)
	Set myInDesign = CreateObject("InDesign.Application.2022")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInDesign.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll	
	myInDesign.Activate
	If myInDesign.Documents.Count <> 0 Then
		If myInDesign.Selection.Count <> 0 Then
			For myCounter = 1 To myInDesign.Selection.Count
					Select Case TypeName(myInDesign.Selection.Item(myCounter))
					Case "Rectangle", "Oval", "Polygon", "GraphicLine"
						If Not (IsEmpty(myObjectList(0))) Then
							ReDim Preserve myObjectList(UBound(myObjectList) + 1)
						End If
						Set myObjectList(UBound(myObjectList)) = myInDesign.Selection.Item(myCounter)
				End Select
			Next
			If Not (IsEmpty(myObjectList(0))) Then
				myDisplayDialog myInDesign, myObjectList
			Else
				MsgBox ("Please select a rectangle, oval, polygon, or graphic line and try again.")
			End If
		Else
			MsgBox ("Please select an object and try again.")
		End If
	Else
		MsgBox ("Please open a document, select an object, and try again.")
	End If
End function
Function myDisplayDialog(myInDesign, myObjectList)
    Set myDialog = myInDesign.Dialogs.Add
    With myDialog
        With .dialogColumns.Add
            With .borderpanels.Add
                With .statictexts.Add
                    .staticLabel = "Effect:"
                End With
                Set myPathEffectButtons = .radiobuttonGroups.Add
                With myPathEffectButtons
                    With .radiobuttonControls.Add
                        .staticLabel = "Punk"
                        .checkedState = True
                    End With
                    With .radiobuttonControls.Add
                        .staticLabel = "Bloat"
                    End With
                    With .radiobuttonControls.Add
                        .staticLabel = "PunkBloat"
                    End With
                    With .radiobuttonControls.Add
                        .staticLabel = "BloatPunk"
                    End With
                    With .radiobuttonControls.Add
                        .staticLabel = "Twirl"
                    End With
                    With .radiobuttonControls.Add
                        .staticLabel = "AntiTwirl"
                    End With
                    With .radiobuttonControls.Add
                        .staticLabel = "RetractAll"
                    End With
                    With .radiobuttonControls.Add
                        .staticLabel = "MakeRectangle"
                    End With
                    With .radiobuttonControls.Add
                        .staticLabel = "MakeOval"
                    End With
                End With
            End With
            With .borderpanels.Add
                With .statictexts.Add
                    .staticLabel = "Options:"
                End With
                With .dialogColumns.Add
                    With .statictexts.Add
                        .staticLabel = "Offset from Center Point:"
                    End With
                    Set myCopyPathCheckbox = .checkboxcontrols.Add
                    myCopyPathCheckbox.staticLabel = "Copy Path"
                    myCopyPathCheckbox.checkedState = False
                End With
                With .dialogColumns.Add
                    Set myOffsetEditbox = .percenteditboxes.Add
                    myOffsetEditbox.editvalue = 60
                End With
            End With
        End With
    End With
    myResult = myDialog.Show
    If myResult = True Then
        myEffect = myPathEffectButtons.selectedbutton
        myOffset = myOffsetEditbox.editvalue
        myCopyPath = myCopyPathCheckbox.checkedState
	myDialog.Destroy
        myPathEffects myInDesign, myEffect, myOffset, myCopyPath, myObjectList
    Else
	myDialog.Destroy
    End If
End Function
Function myPathEffects(myInDesign, myEffect, myOffset, myCopyPath, myObjectList)
For myCounter = 0 to ubound(myObjectList)

	Set myObject = myObjectList(myCounter)

	If myCopyPath = True Then
		Set myObject = myObject.Duplicate
	End If
	myBounds = myObject.geometricBounds
	For myPathCounter = 1 To myObject.Paths.Count
       		myEntirePath = myObject.Paths.Item(myPathCounter).entirePath
		myNewEntirePath = myPathEffect(myEntirePath, myEffect, myBounds, myOffset)
                myObject.Paths.Item(myPathCounter).entirePath = myNewEntirePath
	Next
    Next
End Function
Function myPathEffect(myEntirePath, myEffect, myBounds, myOffset)
    Dim myPoint(2)
    pi = 3.14159265358979
    myAngle = 90*(pi/180)
    myXCenter = myBounds(1) + ((myBounds(3) - myBounds(1)) / 2)
    myYCenter = myBounds(0) + ((myBounds(2) - myBounds(0)) / 2)
    Rem ConvertToRectangle and ConvertToOval are special cases.
    If myEffect < 7 Then
        ReDim myPointArray(UBound(myEntirePath))
        For myPointCounter = 0 To UBound(myEntirePath)
            myPathPoint = myEntirePath(myPointCounter)
            If UBound(myPathPoint) > 1 Then
                myAnchor = myPathPoint(1)
            Else
                myAnchor = myPathPoint
            End If
            myX1 = myAnchor(0)
            myY1 = myAnchor(1)
            myXOffset = myXCenter - myX1
            myYOffset = myYCenter - myY1
            myX = myXOffset * (myOffset * 0.01)
            myY = myYOffset * (myOffset * 0.01)
            Select Case myEffect
                Case 0 'Punk
                    myX2 = myXCenter - myX
                    myY2 = myYCenter - myY
                    myPoint(0) = Array(myX2, myY2)
                    myPoint(1) = myAnchor
                    myPoint(2) = Array(myX2, myY2)
                Case 1 'Bloat
                    myX2 = myX1 - myX
                    myY2 = myY1 - myY
                    myPoint(0) = Array(myX2, myY2)
                    myPoint(1) = myAnchor
                    myPoint(2) = Array(myX2, myY2)
                Case 2 'PunkBloat
                    myX2 = myXCenter - myX
                    myY2 = myYCenter - myY
                    myX3 = myX1 - (myXOffset - myX)
                    myY3 = myY1 - (myYOffset - myY)
                    myPoint(0) = Array(myX2, myY2)
                    myPoint(1) = myAnchor
                    myPoint(2) = Array(myX3, myY3)
                Case 3 'BloatPunk
                    myX2 = myXCenter - myX
                    myY2 = myYCenter - myY
                    myX3 = myX1 - (myXOffset - myX)
                    myY3 = myY1 - (myYOffset - myY)
                    myPoint(0) = Array(myX3, myY3)
                    myPoint(1) = myAnchor
                    myPoint(2) = Array(myX2, myY2)
                Case 4 'Twirl
                    myX2 = myXCenter - myX
                    myY2 = myYCenter - myY
                    myX3 = myX1 - (((myX * Cos(myAngle)) - (myY * Sin(myAngle))))
                    myY3 = myY1 - (((myX * Sin(myAngle)) + (myY * Cos(myAngle))))
                    myPoint(0) = Array(myX3, myY3)
                    myPoint(1) = myAnchor
                    myPoint(2) = Array(myX2, myY2)
                Case 5 'Antitwirl
                    myX2 = myXCenter - myX
                    myY2 = myYCenter - myY
                    myX3 = myX1 + (((myX * Cos(myAngle)) - (myY * Sin(myAngle))))
                    myY3 = myY1 + (((myX * Sin(myAngle)) + (myY * Cos(myAngle))))
                    myPoint(0) = Array(myX2, myY2)
                    myPoint(1) = myAnchor
                    myPoint(2) = Array(myX3, myY3)
                Case 6 'RetractAll
                    myPoint(0) = myAnchor
                    myPoint(1) = myAnchor
                    myPoint(2) = myAnchor
            End Select
            myPointArray(myPointCounter) = myPoint
        Next
    Else
        If myEffect = 7 Then
            Rem Convert to rectangle
            myPointArray = Array(Array(myBounds(1), myBounds(0)), Array(myBounds(3), myBounds(0)), Array(myBounds(3), myBounds(3)), Array(myBounds(1), myBounds(3)))
        Else
            Rem Convert to oval
            ReDim myPointArray(3)
            myMagicConstant = 0.552284746667
            myXOffset = ((myBounds(3) - myBounds(1)) / 2) * myMagicConstant
            myYOffset = ((myBounds(2) - myBounds(0)) / 2) * myMagicConstant
            'myPointArray(0) = Array(Array(myBounds(1), myYCenter - myYOffset), Array(myBounds(1), myYCenter), Array(myBounds(1), myYCenter + myYOffset))
            myPointA = Array(myBounds(1), myYCenter - myYOffset)
            myPointB = Array(myBounds(1), myYCenter)
            myPointC = Array(myBounds(1), myYCenter + myYOffset)
            myPointArray(0) = Array(myPointA, myPointB, myPointC)
            'myPointArray(1) = Array(Array(myXCenter - myXOffset, myBounds(2)), Array(myXCenter, myBounds(2)), Array(myXCenter + myXOffset), Array(myBounds(2)))
            myPointA = Array(myXCenter - myXOffset, myBounds(2))
            myPointB = Array(myXCenter, myBounds(2))
            myPointC = Array(myXCenter + myXOffset, myBounds(2))
            myPointArray(1) = Array(myPointA, myPointB, myPointC)
            'myPointArray(2) = Array(Array(myBounds(3), myYCenter + myYOffset), Array(myBounds(3), myYCenter), Array(myBounds(3), myYCenter - myYOffset))
            myPointA = Array(myBounds(3), myYCenter + myYOffset)
            myPointB = Array(myBounds(3), myYCenter)
            myPointC = Array(myBounds(3), myYCenter - myYOffset)
            myPointArray(2) = Array(myPointA, myPointB, myPointC)
            'myPointArray(3) = Array(Array(myXCenter + myXOffset, myBounds(0)), Array(myXCenter, myBounds(0)), Array(myXCenter - myXOffset, myBounds(0)))
            myPointA = Array(myXCenter + myXOffset, myBounds(0))
            myPointB = Array(myXCenter, myBounds(0))
            myPointC = Array(yXCenter - myXOffset, myBounds(0))
            myPointArray(3) = Array(myPointA, myPointB, myPointC)
        End If
    End If
    myPathEffect = myPointArray
End Function

'' SIG '' Begin signature block
'' SIG '' MIIhPgYJKoZIhvcNAQcCoIIhLzCCISsCAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' +aOceaAAK82jPDgry1WmbnuoYJgqEWpxu8apOaqC3wag
'' SIG '' ggyUMIIF0DCCBLigAwIBAgIQCHK5i9aO5k82w+FiDw5C
'' SIG '' dzANBgkqhkiG9w0BAQsFADBsMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2Vy
'' SIG '' dCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMB4XDTIw
'' SIG '' MTIxOTAwMDAwMFoXDTIyMTIyMTIzNTk1OVowgeYxEzAR
'' SIG '' BgsrBgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIB
'' SIG '' AhMIRGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3Jn
'' SIG '' YW5pemF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYD
'' SIG '' VQQGEwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNh
'' SIG '' biBKb3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYD
'' SIG '' VQQLEyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29w
'' SIG '' eSwgTXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKraHbKp
'' SIG '' 7LWhQb1eUijAwzznOPnL0ar6Bh5IyTX0X3Nmx0y/zOPp
'' SIG '' A769ixYCLdufIms+U9xBOpXey6jajunMtomUtqLHkYMN
'' SIG '' DT2jzWOCqLvnwrHjehFxLYwYIt9ymU0VqJHPcIO+0lfA
'' SIG '' s4ZoskzD5OepJsCVjURfwILDS/l51c42dKXqbPmr25vz
'' SIG '' UQBlKIg7JV7JJGj29DQMOeCI9LSY4dAUYsfaEfDx0dcb
'' SIG '' T/oDlUZAH/mGrvFonoqGwLDNNSpWkFauC3ryUlgMJ6if
'' SIG '' JX9iZIrdm6Glo/EvxbsHMzsL2TclgBXoa0mYq4PYgMH1
'' SIG '' 5XYNA9y4x7QNLRmWPpXU+4gnfN0CAwEAAaOCAfEwggHt
'' SIG '' MB8GA1UdIwQYMBaAFI/ofvBtMmoABSPHcJdqOpD/a+rU
'' SIG '' MB0GA1UdDgQWBBS5nvze3WzR/65rffm/COInbJUTtzAu
'' SIG '' BgNVHREEJzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVM
'' SIG '' QVdBUkUtMjc0ODEyOTAOBgNVHQ8BAf8EBAMCB4AwEwYD
'' SIG '' VR0lBAwwCgYIKwYBBQUHAwMwewYDVR0fBHQwcjA3oDWg
'' SIG '' M4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0VWQ29k
'' SIG '' ZVNpZ25pbmdTSEEyLWcxLmNybDA3oDWgM4YxaHR0cDov
'' SIG '' L2NybDQuZGlnaWNlcnQuY29tL0VWQ29kZVNpZ25pbmdT
'' SIG '' SEEyLWcxLmNybDBLBgNVHSAERDBCMDcGCWCGSAGG/WwD
'' SIG '' AjAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
'' SIG '' Y2VydC5jb20vQ1BTMAcGBWeBDAEDMH4GCCsGAQUFBwEB
'' SIG '' BHIwcDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
'' SIG '' aWNlcnQuY29tMEgGCCsGAQUFBzAChjxodHRwOi8vY2Fj
'' SIG '' ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRFVkNvZGVT
'' SIG '' aWduaW5nQ0EtU0hBMi5jcnQwDAYDVR0TAQH/BAIwADAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAQEALl6DDJXB+ruS0J/n4zd6
'' SIG '' IxqKGcJnnn72tgm50zJjxjqD9f4gMlY5lFA4Dcz9D6ur
'' SIG '' Yc734LqeT9p+oUv2PI4KdFMpSmhdrKLkI8eTK46NHVW8
'' SIG '' U/GZctdsVZR1JvtI1ByrH/DkQS7HTKWwtbyOkKU7lfYK
'' SIG '' HIS+qUso64cM6M2asUym8CdN/3FbwJ9dGJDX9yfMISbX
'' SIG '' oIDfInSnVDD+Z9EnnpsEw9obZwNHaGdd1NJRuPrlwatk
'' SIG '' YdBJuo5kN5/eBMYb95FbK8zZf8e+5FTnEJ0PmxRakjlF
'' SIG '' xh5Zg3CCjiIjr3w/uUkOaa2PjpkNy/vuUYxCuJb53Ca6
'' SIG '' i+n/WMWWjYJLNDCCBrwwggWkoAMCAQICEAPxtOFfOoLx
'' SIG '' FJZ4s9fYR1wwDQYJKoZIhvcNAQELBQAwbDELMAkGA1UE
'' SIG '' BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
'' SIG '' A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMi
'' SIG '' RGlnaUNlcnQgSGlnaCBBc3N1cmFuY2UgRVYgUm9vdCBD
'' SIG '' QTAeFw0xMjA0MTgxMjAwMDBaFw0yNzA0MTgxMjAwMDBa
'' SIG '' MGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
'' SIG '' dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
'' SIG '' KzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmlu
'' SIG '' ZyBDQSAoU0hBMikwggEiMA0GCSqGSIb3DQEBAQUAA4IB
'' SIG '' DwAwggEKAoIBAQCnU/oPsrUT8WTPhID8roA10bbXx6Ms
'' SIG '' rBosrPGErDo1EjqSkbpX5MTJ8y+oSDy31m7clyK6UXlh
'' SIG '' r0MvDbebtEkxrkRYPqShlqeHTyN+w2xlJJBVPqHKI3zF
'' SIG '' QunEemJFm33eY3TLnmMl+ISamq1FT659H8gTy3WbyeHh
'' SIG '' ivgLDJj0yj7QRap6HqVYkzY0visuKzFYZrQyEJ+d8FKh
'' SIG '' 7+g+03byQFrc+mo9G0utdrCMXO42uoPqMKhM3vELKlhB
'' SIG '' iK4AiasD0RaCICJ2615UOBJi4dJwJNvtH3DSZAmALeK2
'' SIG '' nc4f8rsh82zb2LMZe4pQn+/sNgpcmrdK0wigOXn93b89
'' SIG '' OgklAgMBAAGjggNYMIIDVDASBgNVHRMBAf8ECDAGAQH/
'' SIG '' AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDAzB/BggrBgEFBQcBAQRzMHEwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBJBggr
'' SIG '' BgEFBQcwAoY9aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENB
'' SIG '' LmNydDCBjwYDVR0fBIGHMIGEMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMIIBxAYDVR0gBIIBuzCC
'' SIG '' AbcwggGzBglghkgBhv1sAwIwggGkMDoGCCsGAQUFBwIB
'' SIG '' Fi5odHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9zc2wtY3Bz
'' SIG '' LXJlcG9zaXRvcnkuaHRtMIIBZAYIKwYBBQUHAgIwggFW
'' SIG '' HoIBUgBBAG4AeQAgAHUAcwBlACAAbwBmACAAdABoAGkA
'' SIG '' cwAgAEMAZQByAHQAaQBmAGkAYwBhAHQAZQAgAGMAbwBu
'' SIG '' AHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEA
'' SIG '' bgBjAGUAIABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBl
'' SIG '' AHIAdAAgAEMAUAAvAEMAUABTACAAYQBuAGQAIAB0AGgA
'' SIG '' ZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABB
'' SIG '' AGcAcgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwA
'' SIG '' aQBtAGkAdAAgAGwAaQBhAGIAaQBsAGkAdAB5ACAAYQBu
'' SIG '' AGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
'' SIG '' ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBl
'' SIG '' AHIAZQBuAGMAZQAuMB0GA1UdDgQWBBSP6H7wbTJqAAUj
'' SIG '' x3CXajqQ/2vq1DAfBgNVHSMEGDAWgBSxPsNpA/i/RwHU
'' SIG '' mCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAGTNK
'' SIG '' DIEzN9utNsnkyTq7tRsueqLi9ENCF56/TqFN4bHb6YHd
'' SIG '' nwHy5IjV6f4J/SHB7F2A0vDWwUPC/ncr2/nXkTPObNWy
'' SIG '' GTvmLtbJk0+IQI7N4fV+8Q/GWVZy6OtqQb0c1UbVfEnK
'' SIG '' ZjgVwb/gkXB3h9zJjTHJDCmiM+2N4ofNiY0/G//V4BqX
'' SIG '' i3zabfuoxrI6Zmt7AbPN2KY07BIBq5VYpcRTV6hg5ucC
'' SIG '' EqC5I2SiTbt8gSVkIb7P7kIYQ5e7pTcGr03/JqVNYUvs
'' SIG '' RkG4Zc64eZ4IlguBjIo7j8eZjKMqbphtXmHGlreKuWEt
'' SIG '' k7jrDgRD1/X+pvBi1JlqpcHB8GSUgDGCFAIwghP+AgEB
'' SIG '' MIGAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xKzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2ln
'' SIG '' bmluZyBDQSAoU0hBMikCEAhyuYvWjuZPNsPhYg8OQncw
'' SIG '' DQYJYIZIAWUDBAIBBQCggZwwGQYJKoZIhvcNAQkDMQwG
'' SIG '' CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
'' SIG '' AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIPJGG7Wd3ZiU
'' SIG '' 9WfPyYQ0d8Doow3FsdDzwpdtSIQv0Z9dMDAGCisGAQQB
'' SIG '' gjcCAQwxIjAgoB6AHABBAGQAbwBiAGUAIABJAG4ARABl
'' SIG '' AHMAaQBnAG4wDQYJKoZIhvcNAQEBBQAEggEAWiRKaR+P
'' SIG '' Qs3HVwje+UubH49UUOvWVv+fZEutSwP7evdcWwB4T+YH
'' SIG '' tgd52lJlv4mCugBVG2wU0hrQ9G3/Sr+bUFXVY8GzezeZ
'' SIG '' E7/L54fi3K3Nt7JqGzWOFdBkoxCAYLJNMmWDGSEAUMsh
'' SIG '' SgUFiRxKS+1FvaC98qkFiDV3hw5hyo5DNrKY8iX8lBlE
'' SIG '' fkTfWd5biIdIOSQe37dfzFAQZpq5Rqa3a2fTJF2Ky4lt
'' SIG '' zQxYIE2GJtnOtY7lkgn68eMEIITDipnYdykbV27UG7CR
'' SIG '' XvE4gX2gOPxKpilPwvQRPPhX1bBPaF9tnIVs2IfkF4vm
'' SIG '' ZfqQUmho799KiVvMB+xjLJ/h16GCEbMwghGvBgorBgEE
'' SIG '' AYI3AwMBMYIRnzCCEZsGCSqGSIb3DQEHAqCCEYwwghGI
'' SIG '' AgEDMQ8wDQYJYIZIAWUDBAIBBQAweAYLKoZIhvcNAQkQ
'' SIG '' AQSgaQRnMGUCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFl
'' SIG '' AwQCAQUABCBy9DF8KEgEG+3oYnoyiDpY+jySkLwbVfPH
'' SIG '' tXUjEC8mlwIRAOWYkIwRosYR+t2GGrjtnToYDzIwMjIw
'' SIG '' NDE4MTkwMjI2WqCCDXwwggbGMIIErqADAgECAhAKekqI
'' SIG '' nsmZQpAGYzhNhpedMA0GCSqGSIb3DQEBCwUAMGMxCzAJ
'' SIG '' BgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5j
'' SIG '' LjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBS
'' SIG '' U0E0MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcN
'' SIG '' MjIwMzI5MDAwMDAwWhcNMzMwMzE0MjM1OTU5WjBMMQsw
'' SIG '' CQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIElu
'' SIG '' Yy4xJDAiBgNVBAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAy
'' SIG '' MDIyIC0gMjCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCC
'' SIG '' AgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx
'' SIG '' 5DxArvurxON4XX5cNur1JY1Do4HrOGP5PIhp3jzSMFEN
'' SIG '' MQe6Rm7po0tI6IlBfw2y1vmE8Zg+C78KhBJxbKFiJgHT
'' SIG '' zsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFqRUIj
'' SIG '' QVr4YNNlLD5+Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRS
'' SIG '' Xw9Q3tRZLER0wDJHGVvimC6P0Mo//8ZnzzyTlU6E6XYY
'' SIG '' mJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHVGBS3BEXz
'' SIG '' 4Di9or16cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2u
'' SIG '' fyguwp7gC0vICNEyu4P6IzzZ/9KMu/dDI9/nw1oFYn5w
'' SIG '' LOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90QQqvuY4J03Sh
'' SIG '' L7BUdsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHX
'' SIG '' L537/M2xwafEDsTvQD4ZOgLUMalpoEn5deGb6GjkagyP
'' SIG '' 6+SxIXuGZ1h+fx/oK+QUshbWgaHK2jCQa+5vdcCwNiay
'' SIG '' CDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tL
'' SIG '' suK2QT3nr6caKMmtYbCgQRgZTu1Hm2GV7T4LYVrqPnqY
'' SIG '' klHNP8lE54CLKUJy93my3YTqJ+7+fXprAgMBAAGjggGL
'' SIG '' MIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIw
'' SIG '' ADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAE
'' SIG '' GTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwHwYDVR0j
'' SIG '' BBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0O
'' SIG '' BBYEFI1kt4kh/lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRT
'' SIG '' MFEwT6BNoEuGSWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNv
'' SIG '' bS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZU
'' SIG '' aW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGD
'' SIG '' MIGAMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdp
'' SIG '' Y2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9jYWNl
'' SIG '' cnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRH
'' SIG '' NFJTQTQwOTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQw
'' SIG '' DQYJKoZIhvcNAQELBQADggIBAA0tI3Sm0fX46kuZPwHk
'' SIG '' 9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76T
'' SIG '' Ot4qOVo5TtiEWaW8G5iq6Gzv0UhpGThbz4k5HXBw2U7f
'' SIG '' IyJs1d/2WcuhwupMdsqh3KErlribVakaa33R9QIJT4LW
'' SIG '' pXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8
'' SIG '' y/pc9+RTv24KfH7X3pjVKWWJD6KcwGX0ASJlx+pedKZb
'' SIG '' NZJQfPQXpodkTz5GiRZjIGvL8nvQNeNKcEiptucdYL0E
'' SIG '' IhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiLfmSi
'' SIG '' ZZQR+24y8fW7OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBV
'' SIG '' eNaY/lRtf3GpSBp43UZ3Lht6wDOK+EoojBKoc88t+dMj
'' SIG '' 8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pIallDrl/q
'' SIG '' +A8GQp3fBmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW0
'' SIG '' 5rUMopml1xVrNQ6F1uAszOAMJLh8UgsemXzvyMjFjFhp
'' SIG '' r6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBFThIcFClYzG/T
'' SIG '' f8u+wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zM
'' SIG '' bbUNrkdjOEcXW28T2moQbh9Jt0RbtAgKh1pZBHYRoad3
'' SIG '' AhMcMIIGrjCCBJagAwIBAgIQBzY3tyRUfNhHrP0oZipe
'' SIG '' WzANBgkqhkiG9w0BAQsFADBiMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2Vy
'' SIG '' dCBUcnVzdGVkIFJvb3QgRzQwHhcNMjIwMzIzMDAwMDAw
'' SIG '' WhcNMzcwMzIyMjM1OTU5WjBjMQswCQYDVQQGEwJVUzEX
'' SIG '' MBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNVBAMT
'' SIG '' MkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBTSEEy
'' SIG '' NTYgVGltZVN0YW1waW5nIENBMIICIjANBgkqhkiG9w0B
'' SIG '' AQEFAAOCAg8AMIICCgKCAgEAxoY1BkmzwT1ySVFVxyUD
'' SIG '' xPKRN6mXUaHW0oPRnkyibaCwzIP5WvYRoUQVQl+kiPNo
'' SIG '' +n3znIkLf50fng8zH1ATCyZzlm34V6gCff1DtITaEfFz
'' SIG '' sbPuK4CEiiIY3+vaPcQXf6sZKz5C3GeO6lE98NZW1Oco
'' SIG '' LevTsbV15x8GZY2UKdPZ7Gnf2ZCHRgB720RBidx8ald6
'' SIG '' 8Dd5n12sy+iEZLRS8nZH92GDGd1ftFQLIWhuNyG7QKxf
'' SIG '' st5Kfc71ORJn7w6lY2zkpsUdzTYNXNXmG6jBZHRAp8By
'' SIG '' xbpOH7G1WE15/tePc5OsLDnipUjW8LAxE6lXKZYnLvWH
'' SIG '' po9OdhVVJnCYJn+gGkcgQ+NDY4B7dW4nJZCYOjgRs/b2
'' SIG '' nuY7W+yB3iIU2YIqx5K/oN7jPqJz+ucfWmyU8lKVEStY
'' SIG '' dEAoq3NDzt9KoRxrOMUp88qqlnNCaJ+2RrOdOqPVA+C/
'' SIG '' 8KI8ykLcGEh/FDTP0kyr75s9/g64ZCr6dSgkQe1CvwWc
'' SIG '' ZklSUPRR8zZJTYsg0ixXNXkrqPNFYLwjjVj33GHek/45
'' SIG '' wPmyMKVM1+mYSlg+0wOI/rOP015LdhJRk8mMDDtbiiKo
'' SIG '' wSYI+RQQEgN9XyO7ZONj4KbhPvbCdLI/Hgl27KtdRnXi
'' SIG '' YKNYCQEoAA6EVO7O6V3IXjASvUaetdN2udIOa5kM0jO0
'' SIG '' zbECAwEAAaOCAV0wggFZMBIGA1UdEwEB/wQIMAYBAf8C
'' SIG '' AQAwHQYDVR0OBBYEFLoW2W1NhS9zKXaaL3WMaiCPnshv
'' SIG '' MB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/nupiuHA9P
'' SIG '' MA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggrBgEF
'' SIG '' BQcDCDB3BggrBgEFBQcBAQRrMGkwJAYIKwYBBQUHMAGG
'' SIG '' GGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBBBggrBgEF
'' SIG '' BQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29t
'' SIG '' L0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQwQwYDVR0f
'' SIG '' BDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcmwwIAYD
'' SIG '' VR0gBBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcBMA0G
'' SIG '' CSqGSIb3DQEBCwUAA4ICAQB9WY7Ak7ZvmKlEIgF+ZtbY
'' SIG '' IULhsBguEE0TzzBTzr8Y+8dQXeJLKftwig2qKWn8acHP
'' SIG '' HQfpPmDI2AvlXFvXbYf6hCAlNDFnzbYSlm/EUExiHQwI
'' SIG '' gqgWvalWzxVzjQEiJc6VaT9Hd/tydBTX/6tPiix6q4XN
'' SIG '' Q1/tYLaqT5Fmniye4Iqs5f2MvGQmh2ySvZ180HAKfO+o
'' SIG '' vHVPulr3qRCyXen/KFSJ8NWKcXZl2szwcqMj+sAngkSu
'' SIG '' mScbqyQeJsG33irr9p6xeZmBo1aGqwpFyd/EjaDnmPv7
'' SIG '' pp1yr8THwcFqcdnGE4AJxLafzYeHJLtPo0m5d2aR8XKc
'' SIG '' 6UsCUqc3fpNTrDsdCEkPlM05et3/JWOZJyw9P2un8WbD
'' SIG '' Qc1PtkCbISFA0LcTJM3cHXg65J6t5TRxktcma+Q4c6um
'' SIG '' AU+9Pzt4rUyt+8SVe+0KXzM5h0F4ejjpnOHdI/0dKNPH
'' SIG '' +ejxmF/7K9h+8kaddSweJywm228Vex4Ziza4k9Tm8heZ
'' SIG '' Wcpw8De/mADfIBZPJ/tgZxahZrrdVcA6KYawmKAr7ZVB
'' SIG '' tzrVFZgxtGIJDwq9gdkT/r+k0fNX2bwE+oLeMt8EifAA
'' SIG '' zV3C+dAjfwAL5HYCJtnwZXZCpimHCUcr5n8apIUP/JiW
'' SIG '' 9lVUKx+A+sDyDivl1vupL0QVSucTDh3bNzgaoSv27dZ8
'' SIG '' /DGCA3YwggNyAgEBMHcwYzELMAkGA1UEBhMCVVMxFzAV
'' SIG '' BgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJE
'' SIG '' aWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2
'' SIG '' IFRpbWVTdGFtcGluZyBDQQIQCnpKiJ7JmUKQBmM4TYaX
'' SIG '' nTANBglghkgBZQMEAgEFAKCB0TAaBgkqhkiG9w0BCQMx
'' SIG '' DQYLKoZIhvcNAQkQAQQwHAYJKoZIhvcNAQkFMQ8XDTIy
'' SIG '' MDQxODE5MDIyNlowKwYLKoZIhvcNAQkQAgwxHDAaMBgw
'' SIG '' FgQUhQjzhlFcs9MHfba0t8B/G0peQd4wLwYJKoZIhvcN
'' SIG '' AQkEMSIEIMRrXjLFs4evtoUXl+2M+jdM4k4o0bnyJS62
'' SIG '' 8NgSPI3mMDcGCyqGSIb3DQEJEAIvMSgwJjAkMCIEIJ2m
'' SIG '' kBXDScbBiXhFujWCrXDIj6QpO9tqvpwr0lOSeeY7MA0G
'' SIG '' CSqGSIb3DQEBAQUABIICAB/OQR08m28d6Q546H5ZlEVG
'' SIG '' u22czlK4r29xz6Z/pjSv0r+HHn3yxUghCmeyc94FB4s2
'' SIG '' gh32nKDYS5SUK8F0k7gEbKuhX9O2qM5DF3UHTncXIPfM
'' SIG '' ZlgUikAm4mL8wyR4+0avUA5Gn8v0t7G06zsb1pRFWvqq
'' SIG '' rBx/j/ReOVgUhi7wntqr4LY3btzaJmOC//KlpQgGX8GT
'' SIG '' Ebc1lLD5TPcst4o0yjDv7001V+281HVqnXAQtfxu5uQ7
'' SIG '' +D04n+MKoR6lR91kWKzYs0Rokkeyei0t9DOQa9EfCLSa
'' SIG '' 5egcnLANrnhidh16TctanSlr58bgYKZUcM3w50Xq7OqT
'' SIG '' ghihRs1EBD6IZ5+8oaSBwMTuvYPap/kH5gRb2CZ6nCCj
'' SIG '' xjT0I69iORB2X4Gn7YFVq6sAHSEt2slx3S9oW8n5e68a
'' SIG '' 3JTPqCtzY3D5M3Ok01PJu91FDftwaCvDaRAE7PHqvqP/
'' SIG '' Z8/yGnwlEsKjK4pu8IVh3I+Ix5RYJfpF/SWBndgrnSSF
'' SIG '' Kq5hquZGJ6jABbqqlB5vdoAcpB/En72gDYA0qt7IExJv
'' SIG '' 10zEOET6dCNZHVr+YZrMeSdSBqgCTzHyC+ke/yq4rsQn
'' SIG '' QHYBjSidCjV2SdyKf+bEA8+jxJaP1Q2NjoyJD3JMVj1P
'' SIG '' LFUBjXWjJ93iv/26KtpEI2+kkNphVPhRCv982yYhQNG7
'' SIG '' End signature block
